**************************************************************************************************
*******************INDIRECT EFFECTS OF DEBT COVENANTS - MP TRANSMISSION **************************
*************************DATE: AUG 2022 **********************************************************
************************ AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data for analysis
use "\\Output\covenants_analysis.dta", clear

//Set up panel
xtset id year, delta(1)

//Global control vars
global controlvars "Lassets Lrevenue Lcash Lgearing Ldebt"

//Set up for Local Projections 
foreach x in loginvestment logstaffexpenses {
forv h = 0/4 {
gen d`x'`h' = f`h'.`x' - l.`x' 				
}
}

//IRF - Investment

forv h = 0/4 {
xtreg dloginvestment`h' c.BTCS_UA#i.Lcovtype_c i.Lcovtype_c l.BTCS_UA l2.BTCS_UA c.BTCS_UA#(c.Lassets c.Lrevenue c.Lcash c.Lgearing c.Ldebt i.gics_sector) $controlvars c.year, fe robust
lincom c.BTCS_UA#0.Lcovtype_c  - c.BTCS_UA#1.Lcovtype_c, level(90)
lincom c.BTCS_UA#0.Lcovtype_c - c.BTCS_UA#2.Lcovtype_c, level(90)
lincom c.BTCS_UA#2.Lcovtype_c - c.BTCS_UA#1.Lcovtype_c, level(90)
}

//IRF - Staff expenses

forv h = 0/4 {
xtreg dloginvestment`h' c.BTCS_UA#i.Lcovtype_c i.Lcovtype_c l.BTCS_UA l2.BTCS_UA c.BTCS_UA#(c.Lassets c.Lrevenue c.Lcash c.Lgearing c.Ldebt i.gics_sector) $controlvars c.year, fe robust
lincom c.BTCS_UA#0.Lcovtype_c  - c.BTCS_UA#1.Lcovtype_c, level(90)
lincom c.BTCS_UA#0.Lcovtype_c - c.BTCS_UA#2.Lcovtype_c, level(90)
lincom c.BTCS_UA#2.Lcovtype_c - c.BTCS_UA#1.Lcovtype_c, level(90)
}

//IRF - Non-mining investment 

preserve
keep if nonmining==1
forv h = 0/4 {
xtreg dloginvestment`h' c.BTCS_UA#i.Lcovtype_c i.Lcovtype_c l.BTCS_UA l2.BTCS_UA c.BTCS_UA#(c.Lassets c.Lrevenue c.Lcash c.Lgearing c.Ldebt i.gics_sector) $controlvars c.year, fe robust
lincom c.BTCS_UA#0.Lcovtype_c  - c.BTCS_UA#1.Lcovtype_c, level(90)
lincom c.BTCS_UA#0.Lcovtype_c - c.BTCS_UA#2.Lcovtype_c, level(90)
lincom c.BTCS_UA#2.Lcovtype_c - c.BTCS_UA#1.Lcovtype_c, level(90)
}
restore

*** Robustness
preserve
drop if breach==1
bysort id: egen sumcov = sum(cov)
sum sumcov
keep if sumcov>=2
forv h = 0/4 {
xtreg dloginvestment`h' c.BTCS_UA#i.Lcovtype_c i.Lcovtype_c l.BTCS_UA l2.BTCS_UA c.BTCS_UA#(c.Lassets c.Lrevenue c.Lcash c.Lgearing c.Ldebt i.gics_sector) $controlvars c.year, fe robust
lincom c.BTCS_UA#0.Lcovtype_c  - c.BTCS_UA#1.Lcovtype_c, level(90)
lincom c.BTCS_UA#0.Lcovtype_c - c.BTCS_UA#2.Lcovtype_c, level(90)
lincom c.BTCS_UA#2.Lcovtype_c - c.BTCS_UA#1.Lcovtype_c, level(90)
}
restore


/// IRF - Aggregate

forv h = 0/4 {
qui xtreg dloginvestment`h' c.BTCS_UA L.BTCS_UA L2.BTCS_UA $controlvars c.year#i.gics_sector, fe robust
replace b1 = _b[c.BTCS_UA]                     if _n == `h'+1
replace u1 = _b[c.BTCS_UA] + 1.645* _se[c.BTCS_UA]  if _n == `h'+1
replace d1 = _b[c.BTCS_UA] - 1.645* _se[c.BTCS_UA]  if _n == `h'+1

eststo  
}

forv h = 0/4 {
qui xtreg dlogstaffexpenses`h' c.BTCS_UA L.BTCS_UA L2.BTCS_UA $controlvars c.year#i.gics_sector, fe robust
replace b1 = _b[c.BTCS_UA]                     if _n == `h'+1
replace u1 = _b[c.BTCS_UA] + 1.645* _se[c.BTCS_UA]  if _n == `h'+1
replace d1 = _b[c.BTCS_UA] - 1.645* _se[c.BTCS_UA]  if _n == `h'+1

eststo  
}
